/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

/**
 * This interface contains non-error SIP status codes.
 */
public interface InfoResponse
{
	/***************** Informational ******************/
	
	/** Trying - some unspecfied action is being taken on behalf of this call **/
	public static final int TRYING = 100;
	/** Ringing **/
	public static final int RINGING = 180;
	/** Call Is Being Forwarded **/
	public static final int FORWARDING = 181;
	/** Queued **/
	public static final int QUEUED = 182;
	
	/***************** Successful ******************/
	
	/** OK - the request has succeeded**/
	public static final int OK = 200;
	
	/***************** Redirection ******************/
	
	/** Multiple Choices - the address in the request resolved to several choices **/
	public static final int REDIRECTION = 300;
	/** Moved Permanently **/
	public static final int PERMMOVE = 301;
	/** Moved Temporarily **/
	public static final int TEMPMOVE = 302;
	/** Use Proxy **/
	public static final int USEPROXY = 305;
	/** Alternative Service - the call was not successful, but alternative services are possible **/
	public static final int ALTSERVICE = 380;
}